##
## Master_states.RData: Final variable corrections and constructions
##


# LAST VARIABLE TRANSFORMATIONS & CORRECTIONS
states$actor[states$actor=="Czech Rep"] <- as.factor("Czech Republic")

states$year <- as.numeric(states$year)
states$year.dummy <- as.factor(states$year)
states$gmi <- as.numeric(states$gmi)

# fix (-88, -77, -66) values
states$xpolity[states$xpolity < -6] <- NA
states$xpolity_quadratic[states$xpolity_quadratic > 50] <- NA

# add autocracy variable
states$xpolity_lowest <- 0
states$xpolity_lowest[states$xpolity < -4] <- 1

# Create regime group variable (useful for graphics)
states$regime <- "anocracy"
states$regime[states$xpolity_highest==1] <- "democracy"
states$regime[states$xpolity_lowest==1] <- "autocracy"
states$regime <- as.factor(states$regime)

# quadratic gender inequality variables
states$wdi.fertility.quadratic <- (states$wdi.fertility)^2
states$ciri_wecon.quadratic <- (states$ciri_wecon)^2
states$ciri_wopol.quadratic <- (states$ciri_wopol)^2
states$ciri_wosoc.quadratic <- (states$ciri_wosoc)^2

states$nsa.rebstrength.quadratic <- states$nsa.rebstrength.mean^2
states$nsa.effterrcont.quadratic <- states$nsa.effterrcont.mean^2

states$xpolity_highest <- as.factor(states$xpolity_highest)
states$xpolity_lowest <- as.factor(states$xpolity_lowest)
states$external_exists <- as.factor(states$external_exists)
states$external_exists[is.na(states$external_exists)] <- 0 # replace 'unknown external support' (NA) by 'no support' (0)
states$type_intrastate <- as.factor(states$type_intrastate)
states$type_internationalized <- as.factor(states$type_internationalized)
states$max_prev <- as.factor(states$max_prev)
states$enemy_max_prev <- as.factor(states$enemy_max_prev)
states$enemy_max_prev_lag <- as.factor(states$enemy_max_prev_lag)
states$ally_max_prev <- as.factor(states$ally_max_prev)
states$ally_max_prev_lag <- as.factor(states$ally_max_prev_lag)
states$pitf_ethwar <- as.factor(states$pitf_ethwar)
states$postc <- as.factor(states$postc)
states$interm <- as.factor(states$interm)
states$conflictyear <- as.factor(states$conflictyear)

states$pitf_ethwar <- as.factor(states$pitf_ethwar) 
states$pitf_revwar <- as.factor(states$pitf_revwar)
states$pitf_genocwar <- as.factor(states$pitf_genocwar)
states$epr_secesswar <- as.factor(states$epr_secesswar)
states$epr_ethwar <- as.factor(states$epr_ethwar)
states$incomp_dummy <- as.factor(states$incomp_dummy)

# Mittelwertzentrierung
states$wdi.rural.percentage.log.mwz <- states$wdi.rural.percentage.log - mean(states$wdi.rural.percentage.log, na.rm=T)
states$mountain_log.mwz <- states$mountain_log - mean(states$mountain_log, na.rm=T)
states$wdi.pop.density.log.mwz <- states$wdi.pop.density.log - mean(states$wdi.pop.density.log, na.rm=T)
states$population_log.mwz <- states$population_log - mean(states$population_log, na.rm=T)
states$duration.mwz <- states$duration - mean(states$duration, na.rm=T)
states$xpolity.mwz <- states$xpolity - mean(states$xpolity, na.rm=T)
states$xpolity_quadratic.mwz <- states$xpolity_quadratic - mean(states$xpolity_quadratic, na.rm=T)
states$taxgdp.mwz <- states$taxgdp - mean(states$taxgdp, na.rm=T)
states$pitf_magfail.mwz <- states$pitf_magfail - mean(states$pitf_magfail, na.rm = T)
states$wdi.fertility.mwz <- states$wdi.fertility - mean(states$wdi.fertility, na.rm=T)
states$ciri_wecon.mwz <- states$ciri_wecon - mean(states$ciri_wecon, na.rm = T)
states$ciri_wopol.mwz <- states$ciri_wopol - mean(states$ciri_wopol, na.rm = T)
states$ciri_wosoc.mwz <- states$ciri_wosoc - mean(states$ciri_wosoc, na.rm = T)
states$wdi.fertility.quadratic.mwz <- states$wdi.fertility.quadratic - mean(states$wdi.fertility.quadratic, na.rm = T)
states$ciri_wecon.quadratic.mwz <- states$ciri_wecon.quadratic - mean(states$ciri_wecon.quadratic, na.rm = T)
states$ciri_wopol.quadratic.mwz <- states$ciri_wopol.quadratic - mean(states$ciri_wopol.quadratic, na.rm = T)
states$ciri_wosoc.quadratic.mwz <- states$ciri_wosoc.quadratic - mean(states$ciri_wosoc.quadratic, na.rm = T)
states$ef.mwz <- states$ef - mean(states$ef, na.rm=T)
states$wdi.GDPcap.log.mwz <- states$wdi.GDPcap.log - mean(states$wdi.GDPcap.log, na.rm=T)
states$unu_gini.mwz <- states$unu_gini - mean(states$unu_gini, na.rm=T)
states$BattleDeaths.log.mwz <- states$BattleDeaths.log - mean(states$BattleDeaths.log, na.rm=T)
states$pitf_genocwar_deathmag.mwz <- states$pitf_genocwar_deathmag - mean(states$pitf_genocwar_deathmag, na.rm=T)
states$ciri_physint.mwz <- states$ciri_physint - mean(states$ciri_physint, na.rm=T)
states$troop_quality.mwz <- states$troop_quality - mean(states$troop_quality, na.rm=T)
states$troop_quality_log[is.infinite(states$troop_quality_log)] <- NA
states$troop_quality_log.mwz <- states$troop_quality_log - mean(states$troop_quality_log, na.rm=T)
states$wdi.energy.mwz <- states$wdi.energy - mean(states$wdi.energy, na.rm=T)
states$wdi.minerals.mwz <- states$wdi.minerals - mean(states$wdi.minerals, na.rm=T)
states$wdi.forest.mwz <- states$wdi.forest - mean(states$wdi.forest, na.rm=T)
states$max_pts.mwz <- states$max_pts - mean(states$max_pts, na.rm=T)
states$nsa.rebstrength.quadratic.mwz <- states$nsa.rebstrength.quadratic - mean(states$nsa.rebstrength.quadratic, na.rm = T)
states$nsa.effterrcont.quadratic.mwz <- states$nsa.effterrcont.quadratic - mean(states$nsa.effterrcont.quadratic, na.rm = T)
states$nsa.effterrcont.mean.mwz <- states$nsa.effterrcont.mean - mean(states$nsa.effterrcont.mean, na.rm = T)

# ciri_* are conflated to dummies to avoid simulating to much precision (cf. Wood / Gibney 2010: p. 376)
states$ciri_disap <- as.factor(states$ciri_disap)
states$ciri_disap.dummy <- 0
states$ciri_disap.dummy[states$ciri_disap == 1 |states$ciri_disap == 2] <- 1
states$ciri_disap.dummy[is.na(states$ciri_disap)] <- NA
states$ciri_disap.dummy <- as.factor(states$ciri_disap.dummy)

states$ciri_kill[states$ciri_kill == -77 | states$ciri_kill == -66] <- NA
states$ciri_kill <- as.factor(states$ciri_kill)
states$ciri_kill.dummy <- 0
states$ciri_kill.dummy[states$ciri_kill == 1 |states$ciri_kill == 2] <- 1
states$ciri_kill.dummy[is.na(states$ciri_kill)] <- NA
states$ciri_kill.dummy <- as.factor(states$ciri_kill.dummy)

states$ciri_polpris <- as.factor(states$ciri_polpris)
states$ciri_polpris.dummy <- 0
states$ciri_polpris.dummy[states$ciri_polpris == 1 |states$ciri_polpris == 2] <- 1
states$ciri_polpris.dummy[is.na(states$ciri_polpris)] <- NA
states$ciri_polpris.dummy <- as.factor(states$ciri_polpris.dummy)

states$ciri_tort <- as.factor(states$ciri_tort)
states$ciri_tort.dummy <- 0
states$ciri_tort.dummy[states$ciri_tort == 1 |states$ciri_tort == 2] <- 1
states$ciri_tort.dummy[is.na(states$ciri_tort)] <- NA
states$ciri_tort.dummy <- as.factor(states$ciri_tort.dummy)

# (enemy/ally)_max_prev_lag are conflated to one dummy 0/1 variable
states$enemy_max_prev.dummy <- 0
states$enemy_max_prev.dummy[is.na(states$enemy_max_prev)] <- NA
states$enemy_max_prev.dummy[states$enemy_max_prev != 0 & !is.na(states$enemy_max_prev)] <- 1
states$enemy_max_prev.dummy <- as.factor(states$enemy_max_prev.dummy)

states$enemy_max_prev_lag.dummy <- 0
states$enemy_max_prev_lag.dummy[is.na(states$enemy_max_prev_lag)] <- NA
states$enemy_max_prev_lag.dummy[states$enemy_max_prev_lag != 0 & !is.na(states$enemy_max_prev_lag)] <- 1
states$enemy_max_prev_lag.dummy <- as.factor(states$enemy_max_prev_lag.dummy)

states$ally_max_prev.dummy <- 0
states$ally_max_prev.dummy[is.na(states$ally_max_prev)] <- NA
states$ally_max_prev.dummy[states$ally_max_prev != 0 & !is.na(states$ally_max_prev)] <- 1
states$ally_max_prev.dummy <- as.factor(states$ally_max_prev.dummy)

states$ally_max_prev_lag.dummy <- 0
states$ally_max_prev_lag.dummy[is.na(states$ally_max_prev_lag)] <- NA
states$ally_max_prev_lag.dummy[states$ally_max_prev_lag != 0 & !is.na(states$ally_max_prev_lag)] <- 1
states$ally_max_prev_lag.dummy <- as.factor(states$ally_max_prev_lag.dummy)

states$max_prev_lag.dummy <- 0
states$max_prev_lag.dummy[is.na(states$max_prev_lag)] <- NA
states$max_prev_lag.dummy[states$max_prev_lag != 0 & !is.na(states$max_prev_lag)] <- 1
states$max_prev_lag.dummy <- as.factor(states$max_prev_lag.dummy)
